/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.util.NodeType;

public final class PhoneNumberFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new PhoneNumberFormatSpecifier();
    private static final PhoneNumberUtil parser = PhoneNumberUtil.getInstance();

    private PhoneNumberFormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationReport report, JsonNode value) {
        String input = value.textValue();
        try {
            if (input.startsWith("+")) {
                parser.parse(input, "ZZ");
            } else {
                parser.parse(input, "FR");
            }
        }
        catch (NumberParseException ignored) {
            report.addMessage("string is not a recognized phone number");
        }
    }
}

