/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.util.NodeType;

public final class ExtendsKeywordValidator
extends KeywordValidator {
    private final Set<JsonNode> schemas = new HashSet<JsonNode>();

    public ExtendsKeywordValidator(JsonNode schema) {
        super(NodeType.values());
        JsonNode node = schema.get("extends");
        if (node.isObject()) {
            this.schemas.add(node);
            return;
        }
        for (JsonNode element : node) {
            this.schemas.add(element);
        }
    }

    @Override
    public void validate(ValidationReport report, JsonNode instance) {
        for (JsonNode schema : this.schemas) {
            JsonSchema.fromNode(report.getSchema(), schema).validate(report, instance);
        }
    }
}

