/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import org.eel.kitchen.jsonschema.format.CSSColorFormatSpecifier;
import org.eel.kitchen.jsonschema.format.CSSStyleFormatSpecifier;
import org.eel.kitchen.jsonschema.format.DateFormatSpecifier;
import org.eel.kitchen.jsonschema.format.DateTimeFormatSpecifier;
import org.eel.kitchen.jsonschema.format.EmailFormatSpecifier;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.format.HostnameFormatSpecifier;
import org.eel.kitchen.jsonschema.format.IPV4FormatSpecifier;
import org.eel.kitchen.jsonschema.format.IPV6FormatSpecifier;
import org.eel.kitchen.jsonschema.format.PhoneNumberFormatSpecifier;
import org.eel.kitchen.jsonschema.format.RegexFormatSpecifier;
import org.eel.kitchen.jsonschema.format.TimeFormatSpecifier;
import org.eel.kitchen.jsonschema.format.URIFormatSpecifier;
import org.eel.kitchen.jsonschema.format.UnixEpochFormatSpecifier;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.util.NodeType;

public final class FormatKeywordValidator
extends KeywordValidator {
    private static final Map<String, FormatSpecifier> specifiers = new HashMap<String, FormatSpecifier>();
    private final FormatSpecifier specifier;

    public FormatKeywordValidator(JsonNode schema) {
        super(NodeType.values());
        this.specifier = specifiers.get(schema.get("format").textValue());
    }

    @Override
    protected void validate(ValidationReport report, JsonNode instance) {
        if (this.specifier != null) {
            this.specifier.validate(report, instance);
        }
    }

    static {
        specifiers.put("date-time", DateTimeFormatSpecifier.getInstance());
        specifiers.put("date", DateFormatSpecifier.getInstance());
        specifiers.put("time", TimeFormatSpecifier.getInstance());
        specifiers.put("utc-millisec", UnixEpochFormatSpecifier.getInstance());
        specifiers.put("regex", RegexFormatSpecifier.getInstance());
        specifiers.put("color", CSSColorFormatSpecifier.getInstance());
        specifiers.put("style", CSSStyleFormatSpecifier.getInstance());
        specifiers.put("phone", PhoneNumberFormatSpecifier.getInstance());
        specifiers.put("uri", URIFormatSpecifier.getInstance());
        specifiers.put("email", EmailFormatSpecifier.getInstance());
        specifiers.put("ip-address", IPV4FormatSpecifier.getInstance());
        specifiers.put("ipv6", IPV6FormatSpecifier.getInstance());
        specifiers.put("host-name", HostnameFormatSpecifier.getInstance());
    }
}

