/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.keyword.NumericKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;

public final class MaximumKeywordValidator
extends NumericKeywordValidator {
    private final boolean exclusive;

    @Override
    protected void validateLong(ValidationReport report, long instanceValue) {
        if (instanceValue < this.longValue) {
            return;
        }
        if (instanceValue > this.longValue) {
            report.addMessage("instance is greater than the required maximum");
            return;
        }
        if (this.exclusive) {
            report.addMessage("instance is not strictly lower than the required maximum");
        }
    }

    @Override
    protected void validateDecimal(ValidationReport report, BigDecimal instanceValue) {
        int cmp = instanceValue.compareTo(this.decimalValue);
        if (cmp < 0) {
            return;
        }
        if (cmp > 0) {
            report.addMessage("instance is greater than the requried maximum");
            return;
        }
        if (this.exclusive) {
            report.addMessage("instance is not strictly lower than the required maximum");
        }
    }

    public MaximumKeywordValidator(JsonNode schema) {
        super("maximum", schema);
        this.exclusive = schema.path("exclusiveMaximum").asBoolean(false);
    }
}

