/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.keyword.NumericKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;

public final class MinimumKeywordValidator
extends NumericKeywordValidator {
    private final boolean exclusive;

    public MinimumKeywordValidator(JsonNode schema) {
        super("minimum", schema);
        this.exclusive = schema.path("exclusiveMinimum").asBoolean(false);
    }

    @Override
    protected void validateLong(ValidationReport report, long instanceValue) {
        if (instanceValue > this.longValue) {
            return;
        }
        if (instanceValue < this.longValue) {
            report.addMessage("instance is lower than the required minimum");
            return;
        }
        if (this.exclusive) {
            report.addMessage("instance is not strictly greater than the required minimum");
        }
    }

    @Override
    protected void validateDecimal(ValidationReport report, BigDecimal instanceValue) {
        int cmp = instanceValue.compareTo(this.decimalValue);
        if (cmp > 0) {
            return;
        }
        if (cmp < 0) {
            report.addMessage("instance is lower than the required minimum");
            return;
        }
        if (this.exclusive) {
            report.addMessage("instance is not strictly greater than the required minimum");
        }
    }
}

