/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.AbstractTypeKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.util.NodeType;

public final class TypeKeywordValidator
extends AbstractTypeKeywordValidator {
    public TypeKeywordValidator(JsonNode schema) {
        super("type", schema);
    }

    @Override
    public void validate(ValidationReport report, JsonNode instance) {
        if (this.typeSet.contains((Object)NodeType.getNodeType(instance))) {
            return;
        }
        ValidationReport fullReport = report.asNew();
        fullReport.addMessage("instance does not match any allowed primitive type");
        for (JsonNode schema : this.schemas) {
            ValidationReport schemaReport = fullReport.asNew();
            JsonSchema.fromNode(report.getSchema(), schema).validate(schemaReport, instance);
            if (schemaReport.isSuccess()) {
                return;
            }
            fullReport.mergeWith(schemaReport);
        }
        report.mergeWith(fullReport);
    }
}

