/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.uri.URIHandlerFactory;
import org.eel.kitchen.util.JsonPointer;

public final class JsonReference {
    private static final Map<JsonRef, JsonNode> cache = new LRUMap(10, 50);
    private static final URIHandlerFactory factory = new URIHandlerFactory();

    private static JsonNode getByID(JsonNode dst, String fragment) {
        if (!dst.isObject()) {
            return MissingNode.getInstance();
        }
        if (dst.has("id")) {
            JsonNode id = dst.get("id");
            if (!id.isTextual()) {
                return MissingNode.getInstance();
            }
            if (id.textValue().replaceFirst("^#", "").equals(fragment)) {
                return dst;
            }
        }
        for (JsonNode child : dst) {
            JsonNode tmp = JsonReference.getByID(child, fragment);
            if (tmp.isMissingNode()) continue;
            return tmp;
        }
        return MissingNode.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonRef recordSchema(JsonNode schema) throws JsonSchemaException {
        JsonRef ret = JsonRef.fromNode(schema, "id");
        if (ret.hasFragment()) {
            throw new JsonSchemaException("a schema locator cannot have a non empty fragment part");
        }
        if (ret.isEmpty()) {
            return ret;
        }
        if (!ret.isAbsolute()) {
            throw new JsonSchemaException("a schema locator must be absolute");
        }
        Map<JsonRef, JsonNode> map = cache;
        synchronized (map) {
            cache.put(ret, schema);
        }
        return ret;
    }

    private static JsonNode localResolve(JsonNode schema, String fragment) {
        try {
            return new JsonPointer(fragment).getPath(schema);
        }
        catch (JsonSchemaException ignored) {
            return JsonReference.getByID(schema, fragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonNode resolveLocation(JsonRef ref) throws IOException {
        JsonNode ret;
        Map<JsonRef, JsonNode> map = cache;
        synchronized (map) {
            ret = cache.get(ref);
            if (ret != null) {
                return ret;
            }
            URI locator = ref.getLocator();
            ret = factory.getHandler(locator).getDocument(locator);
            cache.put(ref, ret);
        }
        return ret;
    }

    public static JsonNode resolveRef(JsonNode schema, JsonNode node) throws JsonSchemaException, IOException {
        JsonNode origin = schema;
        JsonNode ret = node;
        LinkedHashSet<JsonRef> reflist = new LinkedHashSet<JsonRef>();
        while (ret.has("$ref")) {
            JsonRef locator = JsonReference.recordSchema(origin);
            JsonRef ref = JsonRef.fromNode(node, "$ref");
            if (!reflist.add(ref = locator.resolve(ref))) {
                throw new JsonSchemaException("ref \"" + ref + "\" loops on itself");
            }
            if (ref.isAbsolute()) {
                origin = JsonReference.resolveLocation(ref);
            }
            ret = JsonReference.localResolve(origin, ref.getFragment());
        }
        return ret;
    }
}

