/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.ref.JsonReference;
import org.eel.kitchen.jsonschema.schema.InvalidJsonSchema;
import org.eel.kitchen.jsonschema.schema.ValidJsonSchema;

public abstract class JsonSchema {
    private static final Map<JsonNode, JsonSchema> cache = Collections.synchronizedMap(new LRUMap(10, 50));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonSchema fromNode(JsonNode parent, JsonNode node) {
        JsonSchema ret;
        JsonNode schemaNode;
        try {
            schemaNode = JsonReference.resolveRef(parent, node);
        }
        catch (IOException e) {
            return new InvalidJsonSchema(e.getMessage());
        }
        catch (JsonSchemaException e) {
            return new InvalidJsonSchema(e.getMessage());
        }
        Map<JsonNode, JsonSchema> map = cache;
        synchronized (map) {
            ret = cache.get(schemaNode);
            if (ret != null) {
                return ret;
            }
            ret = schemaNode.isObject() ? new ValidJsonSchema(parent, schemaNode) : new InvalidJsonSchema("schema is not an object");
            cache.put(schemaNode, ret);
        }
        return ret;
    }

    public static JsonSchema fromNode(JsonNode node) {
        return JsonSchema.fromNode(node, node);
    }

    public abstract void validate(ValidationReport var1, JsonNode var2);

    static {
        cache.put(null, new InvalidJsonSchema("schema is null"));
    }
}

