/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.NodeType;

public final class ArrayChildrenSyntaxChecker
implements SyntaxChecker {
    private final EnumSet<NodeType> allowedChildrenTypes;
    private final String keyword;

    public ArrayChildrenSyntaxChecker(String keyword, NodeType type, NodeType ... other) {
        this.keyword = keyword;
        this.allowedChildrenTypes = EnumSet.of(type, other);
    }

    @Override
    public void checkValue(ValidationReport report, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.isArray()) {
            return;
        }
        for (JsonNode value : node) {
            if (this.allowedChildrenTypes.contains((Object)NodeType.getNodeType(value))) continue;
            report.addMessage("wrong element type in array");
        }
    }
}

