/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;

public final class EnumSyntaxChecker
implements SyntaxChecker {
    private static final SyntaxChecker instance = new EnumSyntaxChecker();

    private EnumSyntaxChecker() {
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    public void checkValue(ValidationReport report, JsonNode schema) {
        HashSet<JsonNode> values = new HashSet<JsonNode>();
        for (JsonNode value : schema.get("enum")) {
            if (values.add(value)) continue;
            report.addMessage("values in an enum must be unique");
            return;
        }
    }
}

