/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.RhinoHelper;

public final class PatternPropertiesSyntaxChecker
implements SyntaxChecker {
    private static final SyntaxChecker instance = new PatternPropertiesSyntaxChecker();

    private PatternPropertiesSyntaxChecker() {
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    public void checkValue(ValidationReport report, JsonNode schema) {
        JsonNode node = schema.get("patternProperties");
        Map properties = CollectionUtils.toMap(node.fields());
        for (Map.Entry entry : properties.entrySet()) {
            if (!RhinoHelper.regexIsValid((String)entry.getKey())) {
                report.addMessage("invalid regex");
                continue;
            }
            if (((JsonNode)entry.getValue()).isObject()) continue;
            report.addMessage("value is not a schema");
        }
    }
}

