/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;

public class URISyntaxChecker
implements SyntaxChecker {
    protected final String keyword;

    public URISyntaxChecker(String keyword) {
        this.keyword = keyword;
    }

    @Override
    public void checkValue(ValidationReport report, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        try {
            new URI(node.textValue());
        }
        catch (URISyntaxException ignored) {
            report.addMessage("not a valid URI");
        }
    }
}

