/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eel.kitchen.jsonschema.uri.HTTPURIHandler;
import org.eel.kitchen.jsonschema.uri.URIHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URIHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(URIHandlerFactory.class);
    private final Map<String, URIHandler> schemeHandlers = new HashMap<String, URIHandler>();

    public URIHandlerFactory() {
        this.schemeHandlers.put("http", new HTTPURIHandler());
    }

    public void registerHandler(String scheme, URIHandler handler) {
        try {
            new URI(scheme, "x", null);
        }
        catch (URISyntaxException ignored) {
            throw new IllegalArgumentException("invalid scheme " + scheme);
        }
        if (this.schemeHandlers.containsKey(scheme)) {
            throw new IllegalArgumentException("scheme " + scheme + " already" + " registered");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        logger.debug("registering URI handler for scheme {}", (Object)scheme);
        this.schemeHandlers.put(scheme, handler);
    }

    public void unregisterHandler(String scheme) {
        logger.debug("unregistering handler for scheme {}", (Object)scheme);
        this.schemeHandlers.remove(scheme);
    }

    public URIHandler getHandler(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("only absolute URIs are supported");
        }
        URIHandler ret = this.schemeHandlers.get(scheme);
        if (ret == null) {
            throw new IllegalArgumentException("unsupported scheme " + scheme);
        }
        return ret;
    }
}

