/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;

public final class JsonPointer {
    public static final JsonPointer ROOT;
    private final String fullPointer;
    private final List<String> elements = new LinkedList<String>();

    public JsonPointer(String input) throws JsonSchemaException {
        String s = input == null ? "" : input.replaceFirst("^#", "");
        this.process(s);
        this.fullPointer = "#" + s;
    }

    private JsonPointer(String fullPointer, List<String> elements) {
        this.fullPointer = fullPointer;
        this.elements.addAll(elements);
    }

    public List<String> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public JsonPointer append(String element) {
        LinkedList<String> newElements = new LinkedList<String>(this.elements);
        this.elements.add(element);
        return new JsonPointer(this.fullPointer + "/" + JsonPointer.refTokenEncode(element), newElements);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    public JsonNode getPath(JsonNode node) {
        JsonNode ret = node;
        for (String pathElement : this.elements) {
            if (!ret.isContainerNode()) {
                return MissingNode.getInstance();
            }
            if (ret.isObject()) {
                ret = ret.path(pathElement);
            } else {
                try {
                    ret = ret.path(Integer.parseInt(pathElement));
                }
                catch (NumberFormatException ignored) {
                    return MissingNode.getInstance();
                }
            }
            if (!ret.isMissingNode()) continue;
            break;
        }
        return ret;
    }

    private void process(String input) throws JsonSchemaException {
        String victim = input;
        while (!victim.isEmpty()) {
            if (!victim.startsWith("/")) {
                throw new JsonSchemaException("Illegal JSON Pointer");
            }
            victim = victim.substring(1);
            String cooked = this.getNextRefToken(victim);
            victim = victim.substring(cooked.length());
            String raw = JsonPointer.refTokenDecode(cooked);
            this.elements.add(raw);
        }
    }

    private String getNextRefToken(String input) throws JsonSchemaException {
        StringBuilder sb = new StringBuilder();
        char[] array = input.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (inEscape) {
                if (c != '^' && c != '/') {
                    throw new JsonSchemaException("illegal JSON Pointer");
                }
                sb.append(c);
                inEscape = false;
                continue;
            }
            if (c == '/') break;
            if (c == '^') {
                inEscape = true;
            }
            sb.append(c);
        }
        if (inEscape) {
            throw new JsonSchemaException("illegal JSON Pointer");
        }
        return sb.toString();
    }

    private static String refTokenDecode(String cooked) {
        StringBuilder sb = new StringBuilder(cooked.length());
        char[] array = cooked.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (c == '^' && !inEscape) {
                inEscape = true;
                continue;
            }
            inEscape = false;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String refTokenEncode(String raw) {
        char[] array;
        StringBuilder sb = new StringBuilder(raw.length());
        for (char c : array = raw.toCharArray()) {
            if (c == '/' || c == '^') {
                sb.append('^');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPointer other = (JsonPointer)obj;
        return this.fullPointer.equals(other.fullPointer);
    }

    public int hashCode() {
        return this.fullPointer.hashCode();
    }

    public String toString() {
        return this.fullPointer;
    }

    static {
        try {
            ROOT = new JsonPointer("");
        }
        catch (JsonSchemaException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

