/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import java.util.ArrayList;
import org.eel.kitchen.jsonschema.format.RepeatJoin;
import org.parboiled.Action;
import org.parboiled.Context;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;

@BuildParseTree
public class CSSColorParser
extends RepeatJoin {
    private static final String[] colorNames = new String[]{"maroon", "red", "orange", "yellow", "olive", "green", "purple", "fuchsia", "lime", "teal", "aqua", "blue", "navy", "black", "gray", "silver", "white"};
    private final Object[] COLORS;

    public CSSColorParser() {
        ArrayList<Rule> rules = new ArrayList<Rule>(colorNames.length);
        for (String color : colorNames) {
            rules.add(this.IgnoreCase(color));
        }
        this.COLORS = rules.toArray();
    }

    static <V> Action<V> RangeCheck(final int start, final int end) {
        if (start > end) {
            throw new IllegalStateException();
        }
        return new Action<V>(){

            public boolean run(Context<V> context) {
                int value;
                try {
                    value = Integer.parseInt(context.getMatch());
                }
                catch (NumberFormatException ignored) {
                    return false;
                }
                return value >= start && value <= end;
            }
        };
    }

    Rule PositiveInteger(int start, int end) {
        return this.Sequence(this.OneOrMore(this.Digit()), CSSColorParser.RangeCheck(start, end), new Object[0]);
    }

    Rule Digit() {
        return this.CharRange('0', '9');
    }

    Rule ColorByName() {
        return this.FirstOf(this.COLORS);
    }

    Rule HexDigit() {
        return this.FirstOf(this.CharRange('a', 'f'), this.CharRange('A', 'F'), new Object[]{this.Digit()});
    }

    Rule ThreeHexDigits() {
        return this.Repeat(3, this.HexDigit());
    }

    Rule CSSHexColor() {
        return this.Sequence(Character.valueOf('#'), this.ThreeHexDigits(), new Object[]{this.Optional(this.ThreeHexDigits())});
    }

    Rule Spaces() {
        return this.ZeroOrMore(this.AnyOf(" \r\n\t\f"));
    }

    Rule Comma() {
        return this.Join(2, this.Spaces(), Character.valueOf(','));
    }

    Rule PercentColorElement() {
        return this.Sequence(this.PositiveInteger(0, 100), Character.valueOf('%'), new Object[0]);
    }

    Rule NumericColorElement() {
        return this.PositiveInteger(0, 255);
    }

    Rule CSSRGBColor() {
        return this.Sequence("rgb(", this.Spaces(), new Object[]{this.FirstOf(this.Join(3, this.PercentColorElement(), this.Comma()), this.Join(3, this.NumericColorElement(), this.Comma()), new Object[0]), this.Spaces(), Character.valueOf(')')});
    }

    public Rule CSSColor() {
        return this.Sequence(this.FirstOf(this.ColorByName(), this.CSSHexColor(), new Object[]{this.CSSRGBColor()}), EOI, new Object[0]);
    }
}

