/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.util.NodeType;

public final class CSSStyleFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new CSSStyleFormatSpecifier();
    private static final Pattern styleElement = Pattern.compile("\\s*[^:]+\\s*:\\s*[^;]+", 2);
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*;\\s*");

    private CSSStyleFormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationReport report, JsonNode value) {
        String[] rules;
        for (String rule : rules = SPLIT_PATTERN.split(value.textValue())) {
            Matcher matcher = styleElement.matcher(rule);
            if (matcher.matches()) continue;
            report.addMessage("string is not a valid CSS 2.1 style");
            return;
        }
    }
}

