/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.util.NodeType;

public final class UnixEpochFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new UnixEpochFormatSpecifier();
    private static final int EPOCH_BITLENGTH = 31;
    private static final BigInteger ONE_THOUSAND = new BigInteger("1000");

    private UnixEpochFormatSpecifier() {
        super(NodeType.INTEGER, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationReport report, JsonNode value) {
        BigInteger epoch = value.bigIntegerValue();
        if (epoch.signum() == -1) {
            report.addMessage("epoch cannot be negative");
            return;
        }
        if ((epoch = epoch.divide(ONE_THOUSAND)).bitLength() > 31) {
            report.addMessage("epoch time would overflow");
        }
    }
}

