/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.util.NodeType;

public abstract class AbstractTypeKeywordValidator
extends KeywordValidator {
    private static final String ANY = "any";
    protected final EnumSet<NodeType> typeSet = EnumSet.noneOf(NodeType.class);
    protected final Set<JsonNode> schemas = new HashSet<JsonNode>();

    protected AbstractTypeKeywordValidator(String keyword, JsonNode schema) {
        super(NodeType.values());
        JsonNode node = schema.get(keyword);
        if (node.isTextual()) {
            this.addSimpleType(node.textValue());
            return;
        }
        for (JsonNode element : node) {
            if (element.isTextual()) {
                this.addSimpleType(element.textValue());
                continue;
            }
            this.schemas.add(element);
        }
    }

    private void addSimpleType(String type) {
        if (ANY.equals(type)) {
            this.typeSet.addAll(EnumSet.allOf(NodeType.class));
            return;
        }
        NodeType tmp = NodeType.fromName(type);
        this.typeSet.add(tmp);
        if (tmp == NodeType.NUMBER) {
            this.typeSet.add(NodeType.INTEGER);
        }
    }
}

