/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.NodeType;
import org.eel.kitchen.util.RhinoHelper;

public final class AdditionalPropertiesKeywordValidator
extends KeywordValidator {
    private final boolean additionalOK;
    private final Set<String> properties = new HashSet<String>();
    private final Set<String> patternProperties = new HashSet<String>();

    public AdditionalPropertiesKeywordValidator(JsonNode schema) {
        super(NodeType.OBJECT);
        this.additionalOK = schema.get("additionalProperties").asBoolean(true);
        if (this.additionalOK) {
            return;
        }
        if (schema.has("properties")) {
            this.properties.addAll(CollectionUtils.toSet(schema.get("properties").fieldNames()));
        }
        if (schema.has("patternProperties")) {
            this.patternProperties.addAll(CollectionUtils.toSet(schema.get("patternProperties").fieldNames()));
        }
    }

    @Override
    public void validate(ValidationReport report, JsonNode instance) {
        if (this.additionalOK) {
            return;
        }
        Set<String> fields = CollectionUtils.toSet(instance.fieldNames());
        fields.removeAll(this.properties);
        HashSet<String> tmp = new HashSet<String>();
        for (String field : fields) {
            for (String regex : this.patternProperties) {
                if (!RhinoHelper.regMatch(regex, field)) continue;
                tmp.add(field);
            }
        }
        fields.removeAll(tmp);
        if (!fields.isEmpty()) {
            report.addMessage("additional properties not permitted");
        }
    }
}

