/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.AbstractTypeKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.util.NodeType;

public final class DisallowKeywordValidator
extends AbstractTypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode schema) {
        super("disallow", schema);
    }

    @Override
    public void validate(ValidationReport report, JsonNode instance) {
        if (this.typeSet.contains((Object)NodeType.getNodeType(instance))) {
            report.addMessage("instance is of a disallowed primitive type");
            return;
        }
        for (JsonNode schema : this.schemas) {
            ValidationReport tmp = new ValidationReport();
            JsonSchema.fromNode(report.getSchema(), schema).validate(tmp, instance);
            if (!tmp.isSuccess()) continue;
            report.addMessage("instance matches a disallowed schema");
            return;
        }
    }
}

