/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.util.NodeType;

public abstract class NumericKeywordValidator
extends KeywordValidator {
    protected final BigDecimal decimalValue;
    protected final long longValue;
    protected final boolean isLong;

    protected NumericKeywordValidator(String keyword, JsonNode schema) {
        super(NodeType.INTEGER, NodeType.NUMBER);
        JsonNode node = schema.get(keyword);
        this.isLong = NumericKeywordValidator.valueIsLong(node);
        this.decimalValue = node.decimalValue();
        this.longValue = node.longValue();
    }

    protected abstract void validateLong(ValidationReport var1, long var2);

    protected abstract void validateDecimal(ValidationReport var1, BigDecimal var2);

    @Override
    public final void validate(ValidationReport report, JsonNode instance) {
        if (NumericKeywordValidator.valueIsLong(instance) && this.isLong) {
            this.validateLong(report, instance.longValue());
        } else {
            this.validateDecimal(report, instance.decimalValue());
        }
    }

    private static boolean valueIsLong(JsonNode node) {
        return NodeType.getNodeType(node) == NodeType.INTEGER && node.canConvertToLong();
    }
}

