/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.schema.JsonSchema;

public final class JsonValidator {
    private final JsonNode schemaNode;

    public JsonValidator(JsonNode schemaNode) {
        this.schemaNode = schemaNode;
    }

    public ValidationReport validate(JsonNode instance) {
        ValidationReport ret = new ValidationReport();
        JsonSchema schema = JsonSchema.fromNode(this.schemaNode);
        schema.validate(ret, instance);
        return ret;
    }

    public ValidationReport validate(String path, JsonNode instance) {
        ObjectNode refNode = JsonNodeFactory.instance.objectNode();
        refNode.put("$ref", path);
        JsonSchema schema = JsonSchema.fromNode(this.schemaNode, (JsonNode)refNode);
        ValidationReport ret = new ValidationReport();
        schema.validate(ret, instance);
        return ret;
    }
}

