/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.util.JsonPointer;

public final class ValidationReport {
    private JsonNode schema;
    private JsonPointer path;
    private final List<String> messages = new LinkedList<String>();

    public ValidationReport asNew() {
        ValidationReport ret = new ValidationReport();
        ret.path = this.path;
        return ret;
    }

    public ValidationReport() {
        try {
            this.path = new JsonPointer("#");
        }
        catch (JsonSchemaException e) {
            throw new RuntimeException("WTF??", e);
        }
    }

    public void addMessage(String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path).append(": ");
        sb.append(message);
        this.messages.add(sb.toString());
    }

    public void setPath(JsonPointer path) {
        this.path = path;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public void setSchema(JsonNode schema) {
        this.schema = schema;
    }

    public JsonNode getSchema() {
        return this.schema;
    }

    public boolean isSuccess() {
        return this.messages.isEmpty();
    }

    public void mergeWith(ValidationReport other) {
        this.messages.addAll(other.messages);
    }

    public List<String> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }
}

