/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;

public final class JsonRef {
    private static final URI EMPTY_URI = URI.create("");
    private static final JsonRef EMPTY = new JsonRef(EMPTY_URI);
    private final URI uri;

    private JsonRef(URI uri) {
        this.uri = uri;
    }

    public static JsonRef fromNode(JsonNode node, String key) throws JsonSchemaException {
        URI uri;
        JsonNode entry = node.path(key);
        if (entry.isMissingNode()) {
            return EMPTY;
        }
        if (!entry.isTextual()) {
            throw new JsonSchemaException("invalid " + key + " entry: not a " + "string");
        }
        try {
            uri = new URI(entry.textValue()).normalize();
        }
        catch (URISyntaxException ignored) {
            throw new JsonSchemaException("invalid " + key + " entry: not a " + "valid URI");
        }
        return new JsonRef(uri);
    }

    public boolean isEmpty() {
        return this.uri.equals(EMPTY_URI);
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute() && !this.hasFragment();
    }

    public JsonRef resolve(JsonRef other) {
        return new JsonRef(this.uri.resolve(other.uri));
    }

    public URI getLocator() {
        try {
            return new URI(this.uri.getScheme(), this.uri.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("WTF???", e);
        }
    }

    public String getFragment() {
        String fragment = this.uri.getFragment();
        if (fragment == null) {
            fragment = "";
        }
        return fragment;
    }

    public boolean hasFragment() {
        return !this.getFragment().isEmpty();
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonRef that = (JsonRef)obj;
        return this.uri.equals(that.uri);
    }

    public String toString() {
        return this.uri.toString();
    }
}

