/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.AdditionalItemsKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.AdditionalPropertiesKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.DependenciesKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.DisallowKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.DivisibleByKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.EnumKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.ExtendsKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.FormatKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.keyword.MaxItemsKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.MaxLengthKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.MaximumKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.MinItemsKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.MinLengthKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.MinimumKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.PatternKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.PropertiesKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.TypeKeywordValidator;
import org.eel.kitchen.jsonschema.keyword.UniqueItemsKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.NodeType;

public final class KeywordFactory {
    private static final KeywordFactory instance = new KeywordFactory();
    private static final Map<String, Class<? extends KeywordValidator>> validators = new HashMap<String, Class<? extends KeywordValidator>>();

    public static KeywordFactory getInstance() {
        return instance;
    }

    private KeywordFactory() {
    }

    public Set<KeywordValidator> getValidators(JsonNode schema) {
        HashSet<KeywordValidator> ret = new HashSet<KeywordValidator>();
        Set<String> set = CollectionUtils.toSet(schema.fieldNames());
        set.retainAll(validators.keySet());
        for (String keyword : set) {
            ret.add(this.buildValidator(validators.get(keyword), schema));
        }
        return ret;
    }

    private KeywordValidator buildValidator(Class<? extends KeywordValidator> c, JsonNode schema) {
        Constructor<? extends KeywordValidator> constructor;
        try {
            constructor = c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException e) {
            return this.invalidValidator(e);
        }
        try {
            return constructor.newInstance(schema);
        }
        catch (InstantiationException e) {
            return this.invalidValidator(e);
        }
        catch (IllegalAccessException e) {
            return this.invalidValidator(e);
        }
        catch (InvocationTargetException e) {
            return this.invalidValidator(e);
        }
    }

    private KeywordValidator invalidValidator(final Exception e) {
        return new KeywordValidator(NodeType.values()){

            @Override
            protected void validate(ValidationReport report, JsonNode instance) {
                report.addMessage("cannot build validator: " + e.getClass().getName() + ": " + e.getMessage());
            }
        };
    }

    static {
        validators.put("additionalItems", AdditionalItemsKeywordValidator.class);
        validators.put("additionalProperties", AdditionalPropertiesKeywordValidator.class);
        validators.put("dependencies", DependenciesKeywordValidator.class);
        validators.put("disallow", DisallowKeywordValidator.class);
        validators.put("divisibleBy", DivisibleByKeywordValidator.class);
        validators.put("enum", EnumKeywordValidator.class);
        validators.put("extends", ExtendsKeywordValidator.class);
        validators.put("format", FormatKeywordValidator.class);
        validators.put("maximum", MaximumKeywordValidator.class);
        validators.put("maxItems", MaxItemsKeywordValidator.class);
        validators.put("maxLength", MaxLengthKeywordValidator.class);
        validators.put("minimum", MinimumKeywordValidator.class);
        validators.put("minItems", MinItemsKeywordValidator.class);
        validators.put("minLength", MinLengthKeywordValidator.class);
        validators.put("pattern", PatternKeywordValidator.class);
        validators.put("properties", PropertiesKeywordValidator.class);
        validators.put("type", TypeKeywordValidator.class);
        validators.put("uniqueItems", UniqueItemsKeywordValidator.class);
    }
}

