/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.ArrayChildrenSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.DependenciesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.DivisibleBySyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.EnumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.ExclusiveMaximumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.ExclusiveMinimumSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.PatternPropertiesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.PatternSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.PositiveIntegerSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.PropertiesSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.TypeKeywordSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.URISyntaxChecker;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.NodeType;

public final class SyntaxValidator {
    private static final Set<JsonNode> done = new HashSet<JsonNode>();
    private static final Map<String, EnumSet<NodeType>> typeChecks = new HashMap<String, EnumSet<NodeType>>();
    private static final Map<String, SyntaxChecker> syntaxChecks = new HashMap<String, SyntaxChecker>();

    private static void addKeyword(String keyword, NodeType ... types) {
        EnumSet<NodeType> set = EnumSet.noneOf(NodeType.class);
        set.addAll(Arrays.asList(types));
        typeChecks.put(keyword, set);
    }

    public static synchronized void validate(ValidationReport report, JsonNode schema) {
        if (done.contains(schema)) {
            return;
        }
        Map fields = CollectionUtils.toMap(schema.fields());
        for (Map.Entry entry : fields.entrySet()) {
            String fieldName = (String)entry.getKey();
            JsonNode child = (JsonNode)entry.getValue();
            EnumSet<NodeType> types = typeChecks.get(fieldName);
            SyntaxChecker checker = syntaxChecks.get(fieldName);
            if (types != null && !types.contains((Object)NodeType.getNodeType(child))) {
                report.addMessage(fieldName + " is of wrong type");
                continue;
            }
            if (checker == null) continue;
            checker.checkValue(report, schema);
        }
        if (report.isSuccess()) {
            done.add(schema);
        }
    }

    static {
        SyntaxValidator.addKeyword("additionalItems", NodeType.BOOLEAN, NodeType.OBJECT);
        SyntaxValidator.addKeyword("additionalProperties", NodeType.BOOLEAN, NodeType.OBJECT);
        SyntaxValidator.addKeyword("dependencies", NodeType.OBJECT);
        syntaxChecks.put("dependencies", DependenciesSyntaxChecker.getInstance());
        SyntaxValidator.addKeyword("description", NodeType.STRING);
        SyntaxValidator.addKeyword("disallow", NodeType.STRING, NodeType.ARRAY);
        syntaxChecks.put("disallow", new TypeKeywordSyntaxChecker("disallow"));
        SyntaxValidator.addKeyword("divisibleBy", NodeType.INTEGER, NodeType.NUMBER);
        syntaxChecks.put("divisibleBy", DivisibleBySyntaxChecker.getInstance());
        SyntaxValidator.addKeyword("enum", NodeType.ARRAY);
        syntaxChecks.put("enum", EnumSyntaxChecker.getInstance());
        SyntaxValidator.addKeyword("exclusiveMinimum", NodeType.BOOLEAN);
        syntaxChecks.put("exclusiveMinimum", ExclusiveMinimumSyntaxChecker.getInstance());
        SyntaxValidator.addKeyword("exclusiveMaximum", NodeType.BOOLEAN);
        syntaxChecks.put("exclusiveMaximum", ExclusiveMaximumSyntaxChecker.getInstance());
        SyntaxValidator.addKeyword("extends", NodeType.OBJECT, NodeType.ARRAY);
        syntaxChecks.put("extends", new ArrayChildrenSyntaxChecker("extends", NodeType.OBJECT, new NodeType[0]));
        SyntaxValidator.addKeyword("format", NodeType.STRING);
        SyntaxValidator.addKeyword("id", NodeType.STRING);
        syntaxChecks.put("id", new URISyntaxChecker("id"));
        SyntaxValidator.addKeyword("items", NodeType.OBJECT, NodeType.ARRAY);
        syntaxChecks.put("items", new ArrayChildrenSyntaxChecker("items", NodeType.OBJECT, new NodeType[0]));
        SyntaxValidator.addKeyword("maximum", NodeType.INTEGER, NodeType.NUMBER);
        SyntaxValidator.addKeyword("maxItems", NodeType.INTEGER);
        syntaxChecks.put("maxItems", new PositiveIntegerSyntaxChecker("maxItems"));
        SyntaxValidator.addKeyword("maxLength", NodeType.INTEGER);
        syntaxChecks.put("maxLength", new PositiveIntegerSyntaxChecker("maxLength"));
        SyntaxValidator.addKeyword("minimum", NodeType.INTEGER, NodeType.NUMBER);
        SyntaxValidator.addKeyword("minItems", NodeType.INTEGER);
        syntaxChecks.put("minItems", new PositiveIntegerSyntaxChecker("minItems"));
        SyntaxValidator.addKeyword("minLength", NodeType.INTEGER);
        syntaxChecks.put("minLength", new PositiveIntegerSyntaxChecker("minLength"));
        SyntaxValidator.addKeyword("pattern", NodeType.STRING);
        syntaxChecks.put("pattern", PatternSyntaxChecker.getInstance());
        SyntaxValidator.addKeyword("patternProperties", NodeType.OBJECT);
        syntaxChecks.put("patternProperties", PatternPropertiesSyntaxChecker.getInstance());
        SyntaxValidator.addKeyword("properties", NodeType.OBJECT);
        syntaxChecks.put("properties", PropertiesSyntaxChecker.getInstance());
        SyntaxValidator.addKeyword("required", NodeType.BOOLEAN);
        SyntaxValidator.addKeyword("title", NodeType.STRING);
        SyntaxValidator.addKeyword("type", NodeType.STRING, NodeType.ARRAY);
        syntaxChecks.put("type", new TypeKeywordSyntaxChecker("type"));
        SyntaxValidator.addKeyword("uniqueItems", NodeType.BOOLEAN);
        SyntaxValidator.addKeyword("$ref", NodeType.STRING);
        syntaxChecks.put("$ref", new URISyntaxChecker("$ref"));
        SyntaxValidator.addKeyword("$schema", NodeType.STRING);
        syntaxChecks.put("$schema", new URISyntaxChecker("$schema"));
    }
}

