/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.jsonschema.schema.KeywordFactory;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.JsonPointer;
import org.eel.kitchen.util.RhinoHelper;

final class ValidJsonSchema
extends JsonSchema {
    private static final JsonNode EMPTY_SCHEMA = JsonNodeFactory.instance.objectNode();
    private static final KeywordFactory factory = KeywordFactory.getInstance();
    private final Set<KeywordValidator> validators;
    private final List<JsonNode> items = new ArrayList<JsonNode>();
    private JsonNode additionalItems = EMPTY_SCHEMA;
    private final Map<String, JsonNode> properties = new HashMap<String, JsonNode>();
    private final Map<String, JsonNode> patternProperties = new HashMap<String, JsonNode>();
    private JsonNode additionalProperties = EMPTY_SCHEMA;
    private final JsonNode parent;

    ValidJsonSchema(JsonNode parent, JsonNode schema) {
        this.parent = parent;
        this.validators = factory.getValidators(schema);
        this.setupArrayNodes(schema);
        this.setupObjectNodes(schema);
    }

    @Override
    public void validate(ValidationReport report, JsonNode instance) {
        JsonPointer current;
        JsonNode oldParent = report.getSchema();
        report.setSchema(this.parent);
        for (KeywordValidator validator : this.validators) {
            validator.validateInstance(report, instance);
        }
        if (!instance.isContainerNode() && !report.isSuccess()) {
            report.setSchema(oldParent);
            return;
        }
        JsonPointer ptr = report.getPath();
        if (instance.isArray()) {
            int i = 0;
            for (JsonNode element : instance) {
                current = ptr.append(i);
                report.setPath(current);
                JsonNode subSchema = this.arrayPath(i);
                JsonSchema.fromNode(this.parent, subSchema).validate(report, element);
                ++i;
            }
            report.setSchema(oldParent);
            report.setPath(ptr);
            return;
        }
        Map map = CollectionUtils.toMap(instance.fields());
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            current = ptr.append(key);
            report.setPath(current);
            for (JsonNode subSchema : this.objectPath(key)) {
                JsonSchema.fromNode(this.parent, subSchema).validate(report, value);
            }
        }
        report.setSchema(oldParent);
        report.setPath(ptr);
    }

    private void setupArrayNodes(JsonNode schema) {
        JsonNode node = schema.path("items");
        if (node.isObject()) {
            this.additionalItems = node;
            return;
        }
        if (node.isArray()) {
            for (JsonNode item : node) {
                this.items.add(item);
            }
        }
        if ((node = schema.path("additionalItems")).isObject()) {
            this.additionalItems = node;
        }
    }

    private void setupObjectNodes(JsonNode schema) {
        JsonNode node = schema.path("properties");
        if (node.isObject()) {
            this.properties.putAll(CollectionUtils.toMap(node.fields()));
        }
        if ((node = schema.path("patternProperties")).isObject()) {
            this.patternProperties.putAll(CollectionUtils.toMap(node.fields()));
        }
        if ((node = schema.path("additionalProperties")).isObject()) {
            this.additionalProperties = node;
        }
    }

    private Collection<JsonNode> objectPath(String path) {
        HashSet<JsonNode> ret = new HashSet<JsonNode>();
        if (this.properties.containsKey(path)) {
            ret.add(this.properties.get(path));
        }
        for (Map.Entry<String, JsonNode> entry : this.patternProperties.entrySet()) {
            if (!RhinoHelper.regMatch(entry.getKey(), path)) continue;
            ret.add(entry.getValue());
        }
        if (ret.isEmpty()) {
            ret.add(this.additionalProperties);
        }
        return ret;
    }

    private JsonNode arrayPath(int index) {
        return index < this.items.size() ? this.items.get(index) : this.additionalItems;
    }
}

