/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.NodeType;

public final class DependenciesSyntaxChecker
implements SyntaxChecker {
    private static final SyntaxChecker instance = new DependenciesSyntaxChecker();

    private DependenciesSyntaxChecker() {
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    public void checkValue(ValidationReport report, JsonNode schema) {
        block4: for (JsonNode value : schema.get("dependencies")) {
            switch (NodeType.getNodeType(value)) {
                case ARRAY: {
                    for (JsonNode element : value) {
                        if (element.isTextual()) continue;
                        report.addMessage("array element is not a string");
                    }
                }
                case OBJECT: 
                case STRING: {
                    continue block4;
                }
            }
            report.addMessage("dependencies element has wrong type");
        }
    }
}

