/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;

public final class DivisibleBySyntaxChecker
implements SyntaxChecker {
    private static final SyntaxChecker instance = new DivisibleBySyntaxChecker();

    private DivisibleBySyntaxChecker() {
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    public void checkValue(ValidationReport report, JsonNode schema) {
        BigDecimal decimal = schema.get("divisibleBy").decimalValue();
        if (BigDecimal.ZERO.compareTo(decimal) == 0) {
            report.addMessage("divisibleBy is 0");
        }
    }
}

