/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;

public final class PositiveIntegerSyntaxChecker
implements SyntaxChecker {
    private final String keyword;

    public PositiveIntegerSyntaxChecker(String keyword) {
        this.keyword = keyword;
    }

    @Override
    public void checkValue(ValidationReport report, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.canConvertToInt()) {
            report.addMessage("value overflow");
            return;
        }
        if (node.intValue() < 0) {
            report.addMessage("value is negative");
        }
    }
}

