/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.util.NodeType;

public final class TypeKeywordSyntaxChecker
implements SyntaxChecker {
    private static final String ANY = "any";
    private final String keyword;

    public TypeKeywordSyntaxChecker(String keyword) {
        this.keyword = keyword;
    }

    @Override
    public void checkValue(ValidationReport report, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.isArray()) {
            this.validateOne(report, node);
            return;
        }
        for (JsonNode value : node) {
            this.validateOne(report, value);
        }
    }

    private void validateOne(ValidationReport report, JsonNode value) {
        if (value.isObject()) {
            return;
        }
        if (!value.isTextual()) {
            report.addMessage("value has wrong type");
            return;
        }
        String s = value.textValue();
        if (ANY.equals(s)) {
            return;
        }
        if (NodeType.fromName(s) == null) {
            report.addMessage("unknown simple type");
        }
    }
}

