/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.bundle;

import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;

public final class KeywordBuilder {
    private final String keyword;
    private SyntaxChecker syntaxChecker;
    private Class<? extends KeywordValidator> validatorClass;

    private KeywordBuilder(String keyword) {
        this.keyword = keyword;
    }

    public static KeywordBuilder forKeyword(String keyword) {
        return new KeywordBuilder(keyword);
    }

    public KeywordBuilder withSyntaxChecker(SyntaxChecker syntaxChecker) {
        this.syntaxChecker = syntaxChecker;
        return this;
    }

    public KeywordBuilder withValidatorClass(Class<? extends KeywordValidator> validatorClass) {
        this.validatorClass = validatorClass;
        return this;
    }

    public Keyword build() {
        return new Keyword(this.keyword, this.syntaxChecker, this.validatorClass);
    }
}

