/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.bundle;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eel.kitchen.jsonschema.bundle.Keyword;

public final class KeywordBundle
implements Iterable<Map.Entry<String, Keyword>> {
    private final Map<String, Keyword> keywords = new HashMap<String, Keyword>();

    KeywordBundle copy() {
        KeywordBundle ret = new KeywordBundle();
        ret.keywords.putAll(this.keywords);
        return ret;
    }

    public void registerKeyword(Keyword keyword) {
        String name = keyword.getName();
        if (this.keywords.containsKey(name)) {
            throw new IllegalArgumentException("keyword \"" + name + "\" " + "already registered");
        }
        this.keywords.put(name, keyword);
    }

    public void unregisterKeyword(String name) {
        this.keywords.remove(name);
    }

    public Map<String, Keyword> getKeywords() {
        return Collections.unmodifiableMap(this.keywords);
    }

    @Override
    public Iterator<Map.Entry<String, Keyword>> iterator() {
        return Collections.unmodifiableMap(this.keywords).entrySet().iterator();
    }
}

