/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.util.NodeType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AbstractDateFormatSpecifier
extends FormatSpecifier {
    private final String errmsg;
    private final DateTimeFormatter dtf;

    protected AbstractDateFormatSpecifier(String fmt, String desc) {
        super(NodeType.STRING, new NodeType[0]);
        this.dtf = DateTimeFormat.forPattern((String)fmt);
        this.errmsg = String.format("string is not a valid %s", desc);
    }

    @Override
    public final void checkValue(ValidationContext context, JsonNode instance) {
        try {
            this.dtf.parseDateTime(instance.textValue());
        }
        catch (IllegalArgumentException ignored) {
            context.addMessage(this.errmsg);
        }
    }
}

