/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InetAddresses;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.util.NodeType;

public final class IPV4FormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new IPV4FormatSpecifier();
    private static final int IPV4_LENGTH = 4;

    private IPV4FormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationContext context, JsonNode value) {
        String ipaddr = value.textValue();
        if (!InetAddresses.isInetAddress((String)ipaddr)) {
            context.addMessage("string is not a valid IPv4 address");
            return;
        }
        if (InetAddresses.forString((String)ipaddr).getAddress().length != 4) {
            context.addMessage("string is not a valid IPv4 address");
        }
    }
}

