/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.util.NodeType;

public final class URIFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new URIFormatSpecifier();

    private URIFormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(ValidationContext context, JsonNode value) {
        try {
            new URI(value.textValue());
        }
        catch (URISyntaxException ignored) {
            context.addMessage("string is not a valid URI");
        }
    }
}

