/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.util.NodeType;

public final class AdditionalItemsKeywordValidator
extends KeywordValidator {
    private boolean additionalOK;
    private int itemsCount = 0;

    public AdditionalItemsKeywordValidator(JsonNode schema) {
        super(NodeType.ARRAY);
        this.additionalOK = schema.get("additionalItems").asBoolean(true);
        if (this.additionalOK) {
            return;
        }
        JsonNode items = schema.path("items");
        if (items.isArray()) {
            this.itemsCount = items.size();
        } else {
            this.additionalOK = true;
        }
    }

    @Override
    public void validate(ValidationContext context, JsonNode instance) {
        if (this.additionalOK) {
            return;
        }
        if (instance.size() > this.itemsCount) {
            context.addMessage("additional items not permitted");
        }
    }
}

