/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.jsonschema.schema.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.NodeType;

public final class DependenciesKeywordValidator
extends KeywordValidator {
    private final Map<String, Set<String>> simple = new HashMap<String, Set<String>>();
    private final Map<String, JsonNode> schemas = new HashMap<String, JsonNode>();

    public DependenciesKeywordValidator(JsonNode schema) {
        super(NodeType.OBJECT);
        Map fields = CollectionUtils.toMap(schema.get("dependencies").fields());
        for (Map.Entry entry : fields.entrySet()) {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isObject()) {
                this.schemas.put(key, value);
                continue;
            }
            this.simple.put(key, this.simpleDepdency(value));
        }
    }

    private Set<String> simpleDepdency(JsonNode value) {
        HashSet<String> ret = new HashSet<String>();
        for (JsonNode tmp : value) {
            ret.add(tmp.textValue());
        }
        if (ret.isEmpty()) {
            ret.add(value.textValue());
        }
        return ret;
    }

    @Override
    public void validate(ValidationContext context, JsonNode instance) {
        Set fields = CollectionUtils.toSet(instance.fieldNames());
        HashMap<String, Set<String>> simpleDeps = new HashMap<String, Set<String>>(this.simple);
        simpleDeps.keySet().retainAll(fields);
        HashSet fullSet = new HashSet();
        for (Set set : simpleDeps.values()) {
            fullSet.addAll(set);
        }
        if (!fields.containsAll(fullSet)) {
            context.addMessage("missing property dependencies");
        }
        HashMap<String, JsonNode> schemaDeps = new HashMap<String, JsonNode>(this.schemas);
        schemaDeps.keySet().retainAll(fields);
        SchemaContainer container = context.getContainer();
        JsonSchemaFactory factory = context.getFactory();
        for (JsonNode node : schemaDeps.values()) {
            JsonSchema subSchema = factory.create(container, node);
            subSchema.validate(context, instance);
        }
    }
}

