/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.AbstractTypeKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.jsonschema.schema.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.util.NodeType;

public final class DisallowKeywordValidator
extends AbstractTypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode schema) {
        super("disallow", schema);
    }

    @Override
    public void validate(ValidationContext context, JsonNode instance) {
        if (this.typeSet.contains((Object)NodeType.getNodeType(instance))) {
            context.addMessage("instance is of a disallowed primitive type");
            return;
        }
        SchemaContainer container = context.getContainer();
        JsonSchemaFactory factory = context.getFactory();
        for (JsonNode schema : this.schemas) {
            ValidationContext tmp = new ValidationContext(context);
            JsonSchema subSchema = factory.create(container, schema);
            subSchema.validate(tmp, instance);
            if (!tmp.isSuccess()) continue;
            context.addMessage("instance matches a disallowed schema");
            return;
        }
    }
}

