/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.NodeType;

public final class KeywordFactory {
    private final Map<String, Class<? extends KeywordValidator>> validators = new HashMap<String, Class<? extends KeywordValidator>>();

    public KeywordFactory(KeywordBundle bundle) {
        for (Map.Entry<String, Keyword> entry : bundle) {
            String keyword = entry.getKey();
            Class<? extends KeywordValidator> validatorClass = entry.getValue().getValidatorClass();
            if (validatorClass == null) continue;
            this.validators.put(keyword, validatorClass);
        }
    }

    public Set<KeywordValidator> getValidators(JsonNode schema) {
        HashSet<KeywordValidator> ret = new HashSet<KeywordValidator>();
        Set<String> set = CollectionUtils.toSet(schema.fieldNames());
        set.retainAll(this.validators.keySet());
        for (String keyword : set) {
            ret.add(this.buildValidator(this.validators.get(keyword), schema));
        }
        return ret;
    }

    private KeywordValidator buildValidator(Class<? extends KeywordValidator> c, JsonNode schema) {
        Constructor<? extends KeywordValidator> constructor;
        try {
            constructor = c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException e) {
            return this.invalidValidator(e);
        }
        try {
            return constructor.newInstance(schema);
        }
        catch (InstantiationException e) {
            return this.invalidValidator(e);
        }
        catch (IllegalAccessException e) {
            return this.invalidValidator(e);
        }
        catch (InvocationTargetException e) {
            return this.invalidValidator(e);
        }
    }

    private KeywordValidator invalidValidator(final Exception e) {
        return new KeywordValidator(NodeType.values()){

            @Override
            protected void validate(ValidationContext context, JsonNode instance) {
                context.addMessage("cannot build validator: " + e.getClass().getName() + ": " + e.getMessage());
            }
        };
    }
}

