/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.keyword.NumericKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;

public final class MaximumKeywordValidator
extends NumericKeywordValidator {
    private final boolean exclusive;

    @Override
    protected void validateLong(ValidationContext context, long instanceValue) {
        if (instanceValue < this.longValue) {
            return;
        }
        if (instanceValue > this.longValue) {
            context.addMessage("instance is greater than the required maximum");
            return;
        }
        if (this.exclusive) {
            context.addMessage("instance is not strictly lower than the required maximum");
        }
    }

    @Override
    protected void validateDecimal(ValidationContext context, BigDecimal instanceValue) {
        int cmp = instanceValue.compareTo(this.decimalValue);
        if (cmp < 0) {
            return;
        }
        if (cmp > 0) {
            context.addMessage("instance is greater than the requried maximum");
            return;
        }
        if (this.exclusive) {
            context.addMessage("instance is not strictly lower than the required maximum");
        }
    }

    public MaximumKeywordValidator(JsonNode schema) {
        super("maximum", schema);
        this.exclusive = schema.path("exclusiveMaximum").asBoolean(false);
    }
}

