/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.util.CollectionUtils;
import org.eel.kitchen.util.NodeType;

public final class PropertiesKeywordValidator
extends KeywordValidator {
    private final Set<String> required = new HashSet<String>();

    public PropertiesKeywordValidator(JsonNode schema) {
        super(NodeType.OBJECT);
        Map map = CollectionUtils.toMap(schema.get("properties").fields());
        for (Map.Entry entry : map.entrySet()) {
            if (!((JsonNode)entry.getValue()).path("required").asBoolean(false)) continue;
            this.required.add((String)entry.getKey());
        }
    }

    @Override
    public void validate(ValidationContext context, JsonNode instance) {
        Set fields = CollectionUtils.toSet(instance.fieldNames());
        if (!fields.containsAll(this.required)) {
            context.addMessage("missing required properties in instance");
        }
    }
}

