/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.AbstractTypeKeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.jsonschema.schema.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.util.NodeType;

public final class TypeKeywordValidator
extends AbstractTypeKeywordValidator {
    public TypeKeywordValidator(JsonNode schema) {
        super("type", schema);
    }

    @Override
    public void validate(ValidationContext context, JsonNode instance) {
        if (this.typeSet.contains((Object)NodeType.getNodeType(instance))) {
            return;
        }
        SchemaContainer container = context.getContainer();
        JsonSchemaFactory factory = context.getFactory();
        ValidationContext ctx = new ValidationContext(context);
        ctx.addMessage("instance does not match any allowed primitive type");
        for (JsonNode schema : this.schemas) {
            ValidationContext tmp = new ValidationContext(ctx);
            JsonSchema subSchema = factory.create(container, schema);
            subSchema.validate(tmp, instance);
            if (tmp.isSuccess()) {
                return;
            }
            ctx.mergeWith(tmp);
        }
        context.mergeWith(ctx);
    }
}

