/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.jsonschema.uri.URIManager;

public class SchemaRegistry {
    private static final URI EMPTY_URI = URI.create("#");
    private final Map<URI, SchemaContainer> containers = new HashMap<URI, SchemaContainer>();
    private final URIManager manager;

    public SchemaRegistry() {
        this.manager = new URIManager();
    }

    public SchemaRegistry(URIManager manager) {
        this.manager = manager;
    }

    public SchemaContainer register(JsonNode node) throws JsonSchemaException {
        if (node == null) {
            throw new IllegalArgumentException("schema is null");
        }
        if (!node.has("id")) {
            return new SchemaContainer(EMPTY_URI, node);
        }
        SchemaContainer container = new SchemaContainer(node);
        URI uri = container.getLocator().getRootAsURI();
        if (this.containers.containsKey(uri)) {
            throw new JsonSchemaException("URI \"" + uri + "\" is already " + "registered");
        }
        this.containers.put(uri, container);
        return container;
    }

    public synchronized SchemaContainer get(URI uri) throws JsonSchemaException {
        SchemaContainer container = this.containers.get(uri);
        if (container == null) {
            container = new SchemaContainer(this.manager.getContent(uri));
            JsonRef expected = new JsonRef(uri);
            JsonRef actual = container.getLocator();
            if (!actual.equals(expected)) {
                throw new JsonSchemaException("URI and id of downloaded schema disagree (URI: " + expected + ", id: " + actual + ")");
            }
            this.containers.put(uri, container);
        }
        return container;
    }
}

