/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.schema.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.util.JsonPointer;

public final class ValidationContext {
    private static final JsonPointer ROOT;
    private SchemaContainer container;
    private JsonSchemaFactory factory;
    private JsonNode schema;
    private final ValidationReport report;

    public ValidationContext() {
        this.report = new ValidationReport(new JsonPointer(ROOT));
    }

    public ValidationContext(JsonPointer path) {
        this.report = new ValidationReport(path);
    }

    public ValidationContext(ValidationContext other) {
        this.container = other.container;
        this.factory = other.factory;
        this.schema = other.schema;
        this.report = new ValidationReport(new JsonPointer(ROOT));
        this.report.setPath(other.getPath());
    }

    public void addMessage(String message) {
        this.report.addMessage(message);
    }

    public void setPath(JsonPointer path) {
        this.report.setPath(path);
    }

    public JsonPointer getPath() {
        return this.report.getPath();
    }

    public void setSchema(JsonNode schema) {
        this.schema = schema;
    }

    public JsonNode getSchema() {
        return this.schema;
    }

    public boolean isSuccess() {
        return this.report.isSuccess();
    }

    public void mergeWith(ValidationContext other) {
        this.report.mergeWith(other.report);
    }

    public List<String> getMessages() {
        return this.report.getMessages();
    }

    public void setFactory(JsonSchemaFactory factory) {
        this.factory = factory;
    }

    public JsonSchemaFactory getFactory() {
        return this.factory;
    }

    public SchemaContainer getContainer() {
        return this.container;
    }

    public void setContainer(SchemaContainer container) {
        this.container = container;
    }

    static {
        try {
            ROOT = new JsonPointer("#");
        }
        catch (JsonSchemaException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

