/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eel.kitchen.util.JsonPointer;

public final class ValidationReport {
    private JsonPointer path;
    private final ListMultimap<JsonPointer, String> msgMap = ArrayListMultimap.create();

    public ValidationReport(JsonPointer path) {
        this.path = path;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public void setPath(JsonPointer path) {
        this.path = path;
    }

    public void addMessage(String message) {
        this.msgMap.put((Object)this.path, (Object)message);
    }

    public boolean isSuccess() {
        return this.msgMap.isEmpty();
    }

    public void mergeWith(ValidationReport other) {
        this.msgMap.putAll(other.msgMap);
    }

    public List<String> getMessages() {
        TreeSet paths = new TreeSet(this.msgMap.keySet());
        ArrayList<String> ret = new ArrayList<String>(this.msgMap.size());
        for (JsonPointer path : paths) {
            for (String msg : this.msgMap.get((Object)path)) {
                ret.add(path + ": " + msg);
            }
        }
        return Collections.unmodifiableList(ret);
    }
}

