/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;

public final class JsonRef {
    private static final URI EMPTY_URI = URI.create("#");
    private static final JsonRef EMPTY = new JsonRef(EMPTY_URI);
    private URI uri;
    private boolean normalized;

    public JsonRef(URI uri) {
        this.process(uri);
    }

    private void process(URI uri) {
        URI normalize = uri.normalize();
        this.normalized = uri.equals(normalize);
        if (normalize.getFragment() == null) {
            try {
                normalize = new URI(normalize.getScheme(), normalize.getSchemeSpecificPart(), "");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("WTF??", e);
            }
        }
        this.uri = normalize;
    }

    public JsonRef(String s) throws JsonSchemaException {
        try {
            this.process(new URI(s));
        }
        catch (URISyntaxException e) {
            throw new JsonSchemaException("invalid URI \"" + s + "\"", e);
        }
    }

    public static JsonRef fromNode(JsonNode node, String key) throws JsonSchemaException {
        JsonNode entry = node.path(key);
        if (entry.isMissingNode()) {
            return EMPTY;
        }
        if (!entry.isTextual()) {
            throw new JsonSchemaException("invalid " + key + " entry: not a " + "string");
        }
        return new JsonRef(entry.textValue());
    }

    public boolean isEmpty() {
        return this.uri.equals(EMPTY_URI);
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute() && !this.hasFragment();
    }

    public JsonRef resolve(JsonRef other) {
        return new JsonRef(this.uri.resolve(other.uri));
    }

    public URI getRootAsURI() {
        try {
            return new URI(this.uri.getScheme(), this.uri.getSchemeSpecificPart(), "");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("WTF???", e);
        }
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public boolean hasFragment() {
        return !this.getFragment().isEmpty();
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonRef that = (JsonRef)obj;
        return this.uri.equals(that.uri);
    }

    public String toString() {
        return this.uri.toString();
    }
}

