/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.SchemaRegistry;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.jsonschema.schema.SchemaNode;

public final class JsonResolver {
    private final SchemaRegistry registry;

    public JsonResolver(SchemaRegistry registry) {
        this.registry = registry;
    }

    public SchemaNode resolve(SchemaNode schemaNode) throws JsonSchemaException {
        JsonNode node;
        LinkedHashSet<JsonRef> refs = new LinkedHashSet<JsonRef>();
        SchemaContainer container = schemaNode.getContainer();
        SchemaNode ret = schemaNode;
        while (this.nodeIsRef(node = ret.getNode())) {
            JsonRef ref = JsonRef.fromNode(node, "$ref");
            ref = container.getLocator().resolve(ref);
            if (!refs.add(ref)) {
                throw new JsonSchemaException("ref loop detected");
            }
            if (!container.contains(ref)) {
                container = this.registry.get(ref.getRootAsURI());
            }
            ret = container.lookupFragment(ref.getFragment());
        }
        return ret;
    }

    private boolean nodeIsRef(JsonNode node) {
        JsonNode refNode = node.path("$ref");
        if (!refNode.isTextual()) {
            return false;
        }
        try {
            new URI(refNode.textValue());
            return true;
        }
        catch (URISyntaxException ignored) {
            return false;
        }
    }
}

