/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.bundle.KeywordBundles;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.SchemaRegistry;
import org.eel.kitchen.jsonschema.ref.JsonResolver;
import org.eel.kitchen.jsonschema.schema.InvalidJsonSchema;
import org.eel.kitchen.jsonschema.schema.JsonSchema;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.jsonschema.schema.SchemaNode;
import org.eel.kitchen.jsonschema.schema.ValidJsonSchema;
import org.eel.kitchen.jsonschema.validator.JsonValidatorFactory;

public final class JsonSchemaFactory {
    private final JsonValidatorFactory validatorFactory = new JsonValidatorFactory(KeywordBundles.defaultBundle());
    private final JsonResolver resolver;
    private final SchemaRegistry registry = new SchemaRegistry();

    public JsonSchemaFactory() {
        this.resolver = new JsonResolver(this.registry);
    }

    public JsonSchema create(JsonNode node) {
        return this.create(node, "#");
    }

    public JsonSchema create(JsonNode node, String path) {
        SchemaNode schemaNode;
        SchemaContainer container;
        try {
            container = this.registry.register(node);
            schemaNode = container.lookupFragment(path);
        }
        catch (JsonSchemaException e) {
            return new InvalidJsonSchema(e.getMessage());
        }
        return this.create(container, schemaNode);
    }

    public JsonSchema create(SchemaContainer container, JsonNode node) {
        SchemaNode schemaNode = new SchemaNode(container, node);
        return this.create(container, schemaNode);
    }

    private JsonSchema create(SchemaContainer container, SchemaNode schemaNode) {
        SchemaNode realNode;
        try {
            realNode = this.resolver.resolve(schemaNode);
        }
        catch (JsonSchemaException e) {
            return new InvalidJsonSchema(e.getMessage());
        }
        return new ValidJsonSchema(this, container, realNode);
    }

    JsonValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }
}

