/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.schema.SchemaNode;
import org.eel.kitchen.util.JsonPointer;

public final class SchemaContainer {
    private final JsonNode schema;
    private final JsonRef locator;

    public SchemaContainer(JsonNode schema) throws JsonSchemaException {
        this.locator = JsonRef.fromNode(schema, "id");
        this.schema = this.cleanup(schema);
        this.checkLocator();
    }

    public SchemaContainer(URI uri, JsonNode node) {
        this.schema = this.cleanup(node);
        this.locator = new JsonRef(uri);
    }

    public JsonRef getLocator() {
        return this.locator;
    }

    public boolean contains(JsonRef ref) {
        JsonRef tmp = this.locator.resolve(ref);
        return this.locator.getRootAsURI().equals(tmp.getRootAsURI());
    }

    public SchemaNode lookupFragment(String fragment) throws JsonSchemaException {
        JsonNode node;
        try {
            node = new JsonPointer(fragment).getPath(this.schema);
        }
        catch (JsonSchemaException ignored) {
            node = this.lookupById(this.schema, fragment);
        }
        if (node.isMissingNode()) {
            throw new JsonSchemaException('\"' + fragment + "\" does not match" + " any path/id in schema");
        }
        return new SchemaNode(this, node);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SchemaContainer that = (SchemaContainer)o;
        return this.locator.equals(that.locator) && this.schema.equals((Object)that.schema);
    }

    public int hashCode() {
        return 31 * this.locator.hashCode() + this.schema.hashCode();
    }

    private JsonNode cleanup(JsonNode schema) {
        if (!schema.has("id")) {
            return schema;
        }
        ObjectNode ret = (ObjectNode)schema.deepCopy();
        ret.remove("id");
        return ret;
    }

    private JsonNode lookupById(JsonNode schema, String fragment) {
        if (!schema.isObject()) {
            return MissingNode.getInstance();
        }
        try {
            JsonRef ref = JsonRef.fromNode(schema, "id");
            if (ref.getFragment().equals(fragment)) {
                return schema;
            }
        }
        catch (JsonSchemaException ignored) {
            // empty catch block
        }
        for (JsonNode node : schema) {
            JsonNode ret = this.lookupById(node, fragment);
            if (ret.isMissingNode()) continue;
            return ret;
        }
        return MissingNode.getInstance();
    }

    private void checkLocator() throws JsonSchemaException {
        if (!this.locator.isAbsolute() && !this.locator.isEmpty()) {
            throw new JsonSchemaException("a parent schema's id must be absolute");
        }
        if (!this.locator.isNormalized()) {
            throw new JsonSchemaException("a parent schema's id must be normalized");
        }
    }
}

